﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
//Namensraum für unser Pseudo-Assembly, das in echt einen Webservice darstellt
using KursBeispiele.Webdienst;

namespace KursBeispiele
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        //Serieller Code
        private void button1_Click(object sender, EventArgs e)
        {
            double x = decimal.ToDouble(numericUpDown1.Value);
            double y = decimal.ToDouble(numericUpDown2.Value);
            //Instanziieren
            ServiceClass sc = new ServiceClass();
            double z = sc.SecretWebOperation(x, y);
            textBox1.AppendText(z.ToString());
            textBox1.AppendText(Environment.NewLine);
        }

        //Paralleler Code
        private void button2_Click(object sender, EventArgs e)
        {
            double x = decimal.ToDouble(numericUpDown1.Value);
            double y = decimal.ToDouble(numericUpDown2.Value);
            //Instanziieren
            ServiceClass sc = new ServiceClass();
            sc.SecretWebOperationCompleted += new SecretWebOperationCompletedEventHandler(sc_SecretWebOperationCompleted);
            sc.SecretWebOperationAsync(x, y);
        }

        //Wird aufgerufen sobald der asynchrone Code Aufruf fertig ist
        private void sc_SecretWebOperationCompleted(object sender, SecretWebOperationCompletedEventArgs e)
        {
            textBox1.AppendText(e.Result.ToString());
            textBox1.AppendText(Environment.NewLine);
        }
    }
}
